/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicalUserInterface;

import datasource.InMemoryDataSource;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import products.WritingImplement;

public class D_CustomisingLayout extends JPanel {
    
    //The datasource that we will be using
    private static InMemoryDataSource datasource = new InMemoryDataSource();
    //Has to be this specific implementation as only this implementation gives us access to the lists.
 
    public D_CustomisingLayout() {
        //Contents of the GUI should be listed as attributes
        
        //Try a grid layout with 1 row - notice all the objects 
        //super(new GridLayout(1,0));
        super(new BorderLayout());
        
        //Try a boder layout with button and combobox on the bottom
        
 
//        PriceListTableModel data =new PriceListTableModel((new InMemoryDataSource()).retrieveList("Demo"));
        //Show a blank list to test the button
        PriceListTableModel data =new PriceListTableModel(datasource.retrieveList("Empty"));
 
        final JTable table = new JTable(data);
        table.setPreferredScrollableViewportSize(new Dimension(1000, 140));
        table.setFillsViewportHeight(true);
 
        //Create the scroll pane and add the table to it.
        JScrollPane scrollPane = new JScrollPane(table);
 
        //Add the scroll pane to this panel.
        add(scrollPane, BorderLayout.CENTER);//add the scrollpane to the center of our layout.
        
        //Create a text field and a button       
//        JTextField listNameField = new JTextField("Demo");
        JButton setListButton = new JButton("Change List");
        //Once the text and button are working make the text field a popup containing all the existing price lists
        JComboBox<String> listNameField = new JComboBox(datasource.lists.keySet().toArray());
        
        //Set the action of the button so that the name of hte list is set to the name tyed in the text field
        setListButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
//                listNameField.setText("Hello World");
//                PriceListTableModel data =new PriceListTableModel(
//                        (new InMemoryDataSource()).retrieveList(listNameField.getText()));
                //To fetch the value from the combobox instead of the text field
                PriceListTableModel data =new PriceListTableModel(
                        datasource.retrieveList((String) listNameField.getSelectedItem()));
                table.setModel(data);
            }
        });
        
        //create a panel to contain the combo box and the button
        JPanel listPanel = new JPanel();
        listPanel.add(listNameField);//add this list to the panel
        listPanel.add(setListButton,BorderLayout.PAGE_END);//add this button to the panel
        //Now add this panel to the top of our border layout
        add(listPanel,BorderLayout.PAGE_START);
    }
 
    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Create and set up the window.
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
 
        //Create and set up the content pane.
        D_CustomisingLayout newContentPane = new D_CustomisingLayout();
        newContentPane.setOpaque(true); //content panes must be opaque
        frame.setContentPane(newContentPane);
 
        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }
 
    public static void main(String[] args) {
        //Add some pricelists to our datasource before we start
        datasource.saveList("Empty",datasource.retrieveList("Demo").filterList(i->false));
        datasource.saveList("Writing Implements",datasource.retrieveList("Demo").filterList(i->i instanceof WritingImplement));
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}

